--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNdsimImport ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCfzpFile
  local LOCfzpFilePath
  local LOCfileColumnArray     = #()
  local LOCobjectsAlreadyExist = false
  local LOCpopupMenu           = undefined
  local LOCbaseTimeRes         = undefined

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNmakeDsimImportPopUpMenu FUNlv =
  (
    DYNdsimImport.LOCpopupMenu = undefined
    if DYNdsimImport.dnListView1.Items.count > 0 then
    (
      local LOCexe = "rcmenu LOCpopupMenu\n"
      LOCexe += "(\n"
      LOCexe += "  menuItem  MNDYNselectAll        checked:false\n"
      LOCexe += "  menuItem  MNDYNselectNone       checked:false\n"
      LOCexe += "  separator MNDYNseparator1\n"
      LOCexe += "  menuItem  MNDYNselectHighAll    checked:false\n"
      LOCexe += "  menuItem  MNDYNselectHighNone   checked:false\n"
      LOCexe += "  separator MNDYNseparator2\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[5] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectTypeAll  checked:false\n"
      LOCexe += "    menuItem  MNDYNselectTypeNone checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on LOCpopupMenu open do\n"
      LOCexe += "  (\n"
      LOCexe += "    MNDYNselectAll.text      = DYNuiResourcesMenus[14]\n"
      LOCexe += "    MNDYNselectNone.text     = DYNuiResourcesMenus[15]\n"
      LOCexe += "    MNDYNselectHighAll.text  = DYNuiResourcesMenus[16]\n"
      LOCexe += "    MNDYNselectHighNone.text = DYNuiResourcesMenus[17]\n"
      LOCexe += "    MNDYNselectTypeAll.text  = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectTypeNone.text = DYNuiResourcesMenus[19]\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectAll  picked do (for i = 1 to DYNdsimImport.dnListView1.Items.count do (DYNdsimImport.dnListView1.Items.item[i-1].checked = true))\n"
      LOCexe += "  on MNDYNselectNone picked do (for i = 1 to DYNdsimImport.dnListView1.Items.count do (DYNdsimImport.dnListView1.Items.item[i-1].checked = false))\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectHighAll  picked do (for i = 1 to DYNdsimImport.dnListView1.SelectedItems.count do (DYNdsimImport.dnListView1.SelectedItems.item[i-1].checked = true))\n"
      LOCexe += "  on MNDYNselectHighNone picked do (for i = 1 to DYNdsimImport.dnListView1.SelectedItems.count do (DYNdsimImport.dnListView1.SelectedItems.item[i-1].checked = false))\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectTypeAll  picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCtype = (filterString DYNdsimImport.dnListView1.selectedItems.item[0].SubItems.item[1].text \" \")[1]\n"
      LOCexe += "    for i = 1 to DYNdsimImport.dnListView1.Items.count do\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCcurrentType = (filterString DYNdsimImport.dnListView1.Items.item[i-1].SubItems.item[1].text \" \")[1]\n"
      LOCexe += "      if LOCtype == LOCcurrentType then DYNdsimImport.dnListView1.Items.item[i-1].checked = true\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectTypeNone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCtype = (filterString DYNdsimImport.dnListView1.selectedItems.item[0].SubItems.item[1].text \" \")[1]\n"
      LOCexe += "    for i = 1 to DYNdsimImport.dnListView1.Items.count do\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCcurrentType = (filterString DYNdsimImport.dnListView1.Items.item[i-1].SubItems.item[1].text \" \")[1]\n"
      LOCexe += "      if LOCtype == LOCcurrentType then DYNdsimImport.dnListView1.Items.item[i-1].checked = false\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += ")\n"

      DYNdsimImport.LOCpopupMenu = Execute LOCexe

      registerRightClickMenu DYNdsimImport.LOCpopupMenu
    )
  )

  --- Ask whether scene should be extended to accommodate animation of object longest animation requirements
  fn DSIMFUNdisplayListBox FUNcaption1 FUNcaption2 FUNarray FUNpreSel =
  (
    ExeStr=("rollout DYNrollout \"" + FUNcaption1 + "\"\n")
    ExeStr+=("(\n")
    ExeStr+=("  local LOCresult = " + (FUNpreSel as string) + "\n")
    ExeStr+=(" label LBDYNlabel \"" + FUNcaption2 + "\" width:230 height:80 pos:[10,10]\n")
    ExeStr+=(" listBox DDDYNlist \"\" height:8\n")
    ExeStr+=(" button BUDYNokok DYNuiResourcesButtons[1] width:84\n")
    ExeStr+=("  on DYNrollout open do\n")
    ExeStr+="  (\n"
    ExeStr+=("   DDDYNlist.items = ")

    if FUNarray.count > 0 then
    (
      ExeStr+=("#(\"")
      for i = 1 to (FUNarray.count - 1) do
      (
        ExeStr+=((FUNarray[i] as string) + "\",\"")
      )
      ExeStr+=((FUNarray[FUNarray.count] as string) + "\")")
    )

    ExeStr+=("   \n")
    ExeStr+=("   DDDYNlist.selection = LOCresult\n")
    ExeStr+=("   setFocus DYNrollout.DDDYNlist\n")
    ExeStr+="  )\n"
    ExeStr+="  on DDDYNlist selected arg do\n"
    ExeStr+="  (\n"
    ExeStr+="   LOCresult = arg\n"
    ExeStr+="  )\n"
    ExeStr+="  on BUDYNokok pressed do destroyDialog DYNrollout\n"
    ExeStr+=")\n"

    local DYNrollout = Execute ExeStr

    createDialog DYNrollout width:250 height:250 modal:true pos:((getDialogPos DYNdsimImport) + [100,100])
    return DYNrollout.LOCresult
  )

  fn DSIMFUNextendScene =
  (
    local LOCnewEndTime = (dnImportObject.GlobalEndTime * frameRate) as time-- ((((dnImportObject.GlobalEndTime/* - dnImportObject.GlobalStartTime*/) / dnImportObject.SpeedMultiplier) + dnImportObject.ShiftTime) * frameRate) as time

    if LOCnewEndTime > (animationRange.end - animationRange.start) then
    (
      local LOCdisplayString = DYNuiResourcesErrorsWarnings[57]
      LOCdisplayString += "\n\n"
      LOCdisplayString += DYNuiResourcesLabels[386] + " " + ((((animationRange.end - animationRange.start) as integer)/TicksPerFrame) as string) + " " + DYNuiResourcesUnitsTime[5]
      LOCdisplayString += "\n"
      LOCdisplayString += DYNuiResourcesLabels[387] + " " + (((LOCnewEndTime as integer)/TicksPerFrame) as string) + " " + DYNuiResourcesUnitsTime[5]
      LOCdisplayString += "\n\n"
      LOCdisplayString += DYNuiResourcesQueries[32]

      if (DYNFUNdisplayDistQuery DYNuiResourcesTitlebars[3] LOCdisplayString) then
      (
        animationRange = interval animationRange.start (LOCnewEndTime as time)
      )
    )
  )

  fn DSIMFUNopenFZPfile FUNfzpFile =
  (
    local LOCsuccessSwitch = true
    dnImportObject.StepIncrement = -1.0

    --- Destroy any previous vehicle data currently in memory (if any exists)
    dnImportObject.Destroy()

    --- now that the file is selected, assign it to the FileName property
    dnImportObject.FileName = FUNfzpFile

    --- Open the file and examine the contents (Could also have called:
    --- openResult = vi.Open FUNfzpFile, But we already set the filename
    --- property so there's no need to specify it)
    local LOCopenResult = dnImportObject.Open()
    if LOCopenResult == false then
    (
      messagebox dnImportObject.ErrorMessage title:DYNuiResourcesTitlebars[1]
    )

    DYNdsimImport.BUDYNitemAdd.enabled         = LOCsuccessSwitch
    DYNdsimImport.BUDYNitemRem.enabled         = LOCsuccessSwitch
    DYNdsimImport.DDDYNobjectType.enabled      = LOCsuccessSwitch
    DYNdsimImport.EDDYNwildCard.enabled        = LOCsuccessSwitch; DYNdsimImport.EDDYNwildCard.text = "*"

    DYNdsimImport.LBDYNstepThreshold.enabled   = LOCsuccessSwitch
    DYNdsimImport.SPDYNstepThreshold.enabled   = LOCsuccessSwitch
    DYNdsimImport.LBDYNshiftTime.enabled       = LOCsuccessSwitch
    DYNdsimImport.SPDYNshiftTime.enabled       = LOCsuccessSwitch
    DYNdsimImport.LBDYNspeedMultiplier.enabled = LOCsuccessSwitch
    DYNdsimImport.SPDYNspeedMultiplier.enabled = LOCsuccessSwitch
    DYNdsimImport.LBDYNstartTime.enabled       = LOCsuccessSwitch
    DYNdsimImport.SPDYNstartTime.enabled       = LOCsuccessSwitch
    DYNdsimImport.SLDYNstartTime.enabled       = LOCsuccessSwitch
    DYNdsimImport.LBDYNendTime.enabled         = LOCsuccessSwitch
    DYNdsimImport.SPDYNendTime.enabled         = LOCsuccessSwitch
    DYNdsimImport.SLDYNendTime.enabled         = LOCsuccessSwitch
  )


  ---SECTION 3 - DEFINE PANEL LAYOUT---
  button BUABOdir                pos:[8,9]   width:155 height:20

  dropdownlist DDDYNobjectType   pos:[170,9]  width:140 enabled:false
  edittext EDDYNwildCard ""      pos:[312,11] width:140 enabled:false text:"*"
  button   BUDYNitemAdd          pos:[454,9]  width:20  height:20 enabled:false iconName:"CivilView/UseWildCard" iconSize:[16,16]
  button   BUDYNitemRem          pos:[477,9]  width:20  height:20 enabled:false iconName:"CivilView/DeselectWildCard" iconSize:[16,16]

  dotNetControl dnListView1 "System.Windows.Forms.ListView"    pos:[8,35]  width:395 height:230 align:#center
  dotNetControl dnListView2 "System.Windows.Forms.ListView"    pos:[8,289] width:395 height:116 align:#center
  dotNetControl dnProgress  "System.Windows.Forms.ProgressBar" pos:[8,449] width:626 height:12

  label LBDYNlistView2           pos:[8,274] width:395

  groupbox GBDYNpart0            pos:[410, 32] width:225 height:133
  label LBDYNstartTime           pos:[420, 52] align:#left width:200
  slider SLDYNstartTime          pos:[420, 67] range:[0.0,9999999.0,0.0] type:#float width:140 enabled:false
  spinner SPDYNstartTime         pos:[554, 76] range:[0.0,9999999.0,0.0] type:#float align:#right fieldwidth:60 enabled:false
  label LBDYNendTime             pos:[420,114] align:#left width:200
  slider SLDYNendTime            pos:[420,129] range:[0.0,9999999.0,0.0] type:#float width:140 enabled:false
  spinner SPDYNendTime           pos:[554,138] range:[0.0,9999999.0,0.0] type:#float align:#right fieldwidth:60 enabled:false

  groupbox GPDYNgroup03          pos:[410,171] width:225 height:70
  label LBDYNstepIncrement       pos:[420,195] align:#left width:125 enabled:false
  dropdownlist DDDYNstepInc ""   pos:[555,192] align:#right width:71 enabled:false items:#("0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1.0", "2.0")
  label LBDYNstepThreshold       pos:[420,218] align:#left width:125 enabled:false
  spinner SPDYNstepThreshold     pos:[552,217] range:[0,99999,2] type:#integer align:#right fieldwidth:60 enabled:false

  groupbox GPDYNgroup08          pos:[410,248] width:225 height:65
  label LBDYNshiftTime           pos:[420,269] align:#left width:125 enabled:false
  spinner SPDYNshiftTime         pos:[552,268] range:[-9999999.0,9999999.0,0.0] type:#float align:#right fieldwidth:60 enabled:false
  label LBDYNspeedMultiplier     pos:[420,290] align:#left width:125 enabled:false
  spinner SPDYNspeedMultiplier   pos:[552,289] range:[1.0,100.0,1] type:#float align:#right fieldwidth:60 enabled:false

  groupbox GPDYNgroup04          pos:[410,319] width:225 height:87
  label LBDYNshiftX              pos:[420,340] align:#left width:125
  spinner SPDYNshiftX            pos:[552,339] range:[-9999999,9999999,0] type:#integer align:#right fieldwidth:60
  label LBDYNshiftY              pos:[420,361] align:#left width:125
  spinner SPDYNshiftY            pos:[552,360] range:[-9999999,9999999,0] type:#integer align:#right fieldwidth:60
  label LBDYNshiftZ              pos:[420,382] align:#left width:125
  spinner SPDYNshiftZ            pos:[552,381] range:[-9999999,9999999,0] type:#float align:#right fieldwidth:60


  button BUDYNhelp width:112     pos:[  8,419] height:22
  button BUDYNokok width:112     pos:[409,419] height:22 enabled:false
  button BUDYNcanc width:112     pos:[522,419] height:22

  label LBDYNstatus              pos:[8,469]   width:626 height:18

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNdsimImport open do
  (
    DYNdsimImport.title               = DYNuiRolloutNames[41]

    GPDYNgroup08.text                 = DYNuiResourcesGroups[109]
    GBDYNpart0.text                   = DYNuiResourcesGroups[110]
    GPDYNgroup03.text                 = DYNuiResourcesGroups[111]
    GPDYNgroup04.text                 = DYNuiResourcesGroups[112]

    BUDYNokok.text                    = DYNuiResourcesButtons[1]
    BUDYNcanc.text                    = DYNuiResourcesButtons[3]
    BUDYNhelp.text                    = DYNuiResourcesButtons[5]
    BUABOdir.text                     = DYNuiResourcesButtons[6]
    BUDYNitemAdd.text                 = DYNuiResourcesButtons[11]
    BUDYNitemRem.text                 = DYNuiResourcesButtons[12]

    LBDYNlistView2.text               = DYNuiResourcesLabels[85]
    LBDYNstatus.text                  = DYNuiResourcesStatusMessages[16]

    LBDYNstepIncrement.text           = DYNuiResourcesLabels[372]
    LBDYNshiftX.text                  = DYNuiResourcesLabels[373]
    LBDYNshiftY.text                  = DYNuiResourcesLabels[374]
    LBDYNshiftZ.text                  = DYNuiResourcesLabels[375]
    LBDYNshiftTime.text               = DYNuiResourcesLabels[376]
    LBDYNspeedMultiplier.text         = DYNuiResourcesLabels[377]
    LBDYNstartTime.text               = DYNuiResourcesLabels[378]
    LBDYNendTime.text                 = DYNuiResourcesLabels[379]
    LBDYNstepThreshold.text           = DYNuiResourcesLabels[380]

    DDDYNobjectType.items             = #(DYNuiResourcesLabels[381])

    LOCfzpFilePath                    = rootNode.DYNrootNodeStore.string03; if LOCfzpFilePath == "" then LOCfzpFilePath = (getdir #import) + "\\*.fzp"
    LOCfzpFile                        = undefined

    --- Read Main INI File Settings
    dnImportObject.PreserveMemorySize = DYNINImemPrecent
    dnImportObject.UseReadOverride    = if DYNINIreadMethod == 0 then false else true
    dnImportObject.UseSingleRead      = if DYNINIreadMethod == 1 then true  else false
    dnImportObject.StepThreshold      = SPDYNstepThreshold.value     = DYNINIstepThreshold

    --- These properties need only be set and assigned prior to calling ProcessImport()
    SPDYNshiftZ.value                 = rootNode.DYNrootNodeStore.float01
    dnImportObject.ShiftX             = SPDYNshiftX.value          = rootNode.DYNrootNodeStore.int04 as float
    dnImportObject.ShiftY             = SPDYNshiftY.value          = rootNode.DYNrootNodeStore.int05 as float

    dnImportObject.ShiftTime          = SPDYNshiftTime.value       = 0.0
    dnImportObject.SpeedMultiplier    = SPDYNspeedMultiplier.value = 1

    dnImportObject.StartTime          = -1.0
    dnImportObject.EndTime            = -1.0
    dnImportObject.StepIncrement      = -1.0
    dnImportObject.TimeAccuracy       = 1

    --dnImportObject.delimiter = ","

    --- Set Up ListView Displays
    dnImportObject.ControlSelectionListView = dnListView1
    dnImportObject.controlVehTypeListView   = dnListView2
    dnImportObject.ControlProgressBar       = dnProgress

    DYNFUNdnListViewStyle dnListView1 true true
    dnListView1.smallimageList = DYNdnSmImageList

    dnListView1.Columns.add DYNuiResourcesLvColumns[56] 74
    dnListView1.Columns.add DYNuiResourcesLvColumns[57] 74
    dnListView1.Columns.add DYNuiResourcesLvColumns[72] 80
    dnListView1.Columns.add DYNuiResourcesLvColumns[73] 80
    dnListView1.Columns.add DYNuiResourcesLvColumns[71] 62
    dnListView1.Columns.item[0].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Left
    dnListView1.Columns.item[1].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[2].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[3].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[4].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center

    DYNFUNdnListViewStyle dnListView2 false true
    dnListView2.smallimageList = DYNdnSmImageList
    dnListView2.Columns.add DYNuiResourcesLvColumns[57] 100
    dnListView2.Columns.add DYNuiResourcesLvColumns[70] 75
    dnListView2.Columns.item[0].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[1].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center

    LOCobjectsAlreadyExist = if objects.count == 0 then false else true
  )

  on DYNdsimImport close do
  (
    --- For lack of a better place, destroy the import object vehicle data
    --- This is done in case we forget to hit the DESTROY button. :-)
    dnImportObject.Destroy()

    LOCfzpFile      = undefined
    LOCfzpFilePath  = undefined
  )

  on dnListView1 MouseUp arg do
  (
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNmakeDsimImportPopUpMenu dnListView1
      if LOCpopupMenu != undefined then popupMenu LOCpopupMenu
    )
  )

  on BUABOdir pressed do
  (
    --- Standard Vehicle Attribute Names for files from Vissim 6.0 and later
    local LOCINICoordFront = "COORDFRONT"
    local LOCINICoordRear = "COORDREAR"
    local LOCINISimSec = "SIMSEC"
    local LOCINIVehNo = "NO"
    local LOCINIVehTypeName = "VEHTYPE\NAME"
    local LOCINIVehTypeNo = "VEHTYPE\NO"
    local LOCINIVehType = "VEHTYPE"

    local LOCtempFzpFile = getOpenFileName caption:DYNuiResourcesTitlebars[8] filename:LOCfzpFilePath types:DYNuiResourcesFileTypes[6]

    if LOCtempFzpFile != undefined then
    (
      LOCfzpFile = LOCtempFzpFile

      DYNdsimImport.title = DYNuiRolloutNames[41] + " [" + (filenamefrompath LOCfzpFile) + "]"
      DSIMFUNopenFZPfile LOCfzpFile

      --- Obtain the columns found in the file, as an array of strings
      LOCfileColumnArray = dnImportObject.GetColumns()

      --- Check if the result of GetColumns is null/undefined and get error
      if LOCfileColumnArray == undefined then
      (
        messagebox dnImportObject.ErrorMessage title:DYNuiResourcesTitlebars[1]
      )
      else
      (
        --- Column references are mandatory fields that must be in the file for this process to work.
        --- If mandatory fields are not expressed in this parameter, an error will be generated.
        /*
          It is possible that the variable names in a VISSIM file might differ from time to time or from
          file to file. Therefore, rather than use variable names explicity to identify fields,
          the columnReferences array allows us to use the positions in this array *alone* to define
          *the names* of each section of data that we need to retrieve. Not all of these names must be
          in the file, but eleven entries must always be passed into this array.

          Item 1: Current Step (usually "t" in Vissim 5.4 and earlier and "SIMSEC" in Vissim 6.0 and later)
          Item 2: Vehicle ID   (usually "VehNr" in Vissim 5.4 and earlier and "NO" in Vissim 6.0 and later)
          Item 3: Vehicle Type (In Vissim 5.4 and earlier preferably "VehTypeName" but if not available, "Type"
                   may also be used. In Vissim 6.0 and later preferably "VEHTYPE\NAME", but "VEHTYPE" may also be used.)
          Item 4: X coordinate (usually WorldX)              (Specifically for Vissim 5.4 and earlier)
          Item 5: Y coordinate (usually WorldY)              (Specifically for Vissim 5.4 and earlier)
          Item 6: Z coordinate (usually WorldZ)              (Specifically for Vissim 5.4 and earlier)
          Item 7: X Rear coordinate (usually RWorldX)        (Specifically for Vissim 5.4 and earlier)
          Item 8: Y Rear Coordinate (usually RWorldY)        (Specifically for Vissim 5.4 and earlier)
          Item 9: Z Rear Coordinate (usually RWorldZ)        (Specifically for Vissim 5.4 and earlier)
          Item 10: XYZ Front Coordinate (usually COORDFRONT) (Specifically for Vissim 6.0 and later)
          Item 11: XYZ Rear Coordinate (usually COORDREAR)   (Specifically for Vissim 6.0 and later)
       */

        --- For files from Vissim 5.4 and earlier, decide which Vissim attribute name to use for Civil View, based on file content.
        --- Our preferred attribute name is ""VehTypeName", but if this is not present in the file try "Type" instead.
        local LOCtypeString540  = DYNINIvehTypeName
        if (findItem LOCfileColumnArray DYNINIvehTypeName) == 0 and (findItem LOCfileColumnArray DYNINIType) != 0 then
           LOCtypeString540  = DYNINIType

        --- For files from Vissim 6.0 and later, our preferred Vehicle Type attribute is "VEHTYPE\NAME". If this attribute is not
        --- present in the file, check for the presence of "VEHTYPE\NO" or "VEHTYPE" as valid alternatives.
        local LOCtypeString600  = LOCINIVehTypeName
        if (findItem LOCfileColumnArray LOCINIVehTypeName) == 0 and (findItem LOCfileColumnArray LOCINIVehTypeNo) != 0 then
             LOCtypeString600 = LOCINIVehTypeNo
        else if (findItem LOCfileColumnArray LOCINIVehTypeName) == 0 and (findItem LOCfileColumnArray LOCINIVehType) != 0 then
             LOCtypeString600 = LOCINIVehType

        --- Set Column References
        local LOCproceedSwitch = false;
        if dnImportObject.IsVissim6FileOrLater then
        (
           LOCproceedSwitch = dnImportObject.SetColumnReferences #(LOCINISimSec, LOCINIVehNo, LOCtypeString600, DYNINIworldX, DYNINIworldY, DYNINIworldZ, DYNINIrWorldX, DYNINIrWorldY, DYNINIrWorldZ, LOCINICoordFront, LOCINICoordRear)
        )
        else
        (
           LOCproceedSwitch = dnImportObject.SetColumnReferences #(DYNINIt, DYNINIvehNr, LOCtypeString540, DYNINIworldX, DYNINIworldY, DYNINIworldZ, DYNINIrWorldX, DYNINIrWorldY, DYNINIrWorldZ, LOCINICoordFront, LOCINICoordRear)
        )

        if not LOCproceedSwitch then
        (
          messagebox dnImportObject.ErrorMessage title:DYNuiResourcesTitlebars[1]
        )

        --- We now decide which of those mandatory fields should actually be read from the file.
        /*
        The names of the fields that we actually want to read and use.
        */
        if LOCproceedSwitch then
        (
          local LOCcolArray = if dnImportObject.IsVissim6FileOrLater then #(LOCINISimSec, LOCINIVehNo, LOCtypeString600, LOCINICoordFront, LOCINICoordRear) else #(DYNINIt, DYNINIvehNr, LOCtypeString540, DYNINIworldX, DYNINIworldY, DYNINIrWorldX, DYNINIrWorldY)

          --- Check whether required columns actually exist
          for ii in LOCcolArray do
          (
            LOCproceedSwitch = false
            for iii in LOCfileColumnArray do
            (
               if (stricmp ii iii) == 0 then
               (
                  LOCproceedSwitch = true
               )
            )

            --- If any of the minimum required vehicle attributes are not present in the file, exit now.
            if not LOCproceedSwitch then
            (
              messagebox (DYNuiResourcesErrorsWarnings[56]) title:DYNuiResourcesTitlebars[1]
              exit
            )
          )

          --- Now actually set the columns
          if LOCproceedSwitch then
          (
            LOCproceedSwitch = dnImportObject.SetColumns LOCcolArray
            if not LOCproceedSwitch then
            (
              messagebox dnImportObject.ErrorMessage title:DYNuiResourcesTitlebars[1]
            )
          )
        )

        --- If the above worked, derive the basic time resolution of the file (must be called after SetColumnRefs and Setcolumns)
        if LOCproceedSwitch then
        (
          LOCbaseTimeRes  = dnImportObject.GetTimeResolution()
          /*
          LOCbaseTimeRes = (ceil (LOCbaseTimeRes * 1000)) / 1000.0
          */
          if LOCbaseTimeRes <= 0.0 then
          (
            LOCproceedSwitch = false
            messagebox dnImportObject.ErrorMessage title:DYNuiResourcesTitlebars[1]
          )
          else
          (
            /*
            -- STEPINCREMENT NOTES --

            This value defaults to -1.0 which indicates that this value is not used in the processing of
            imported data. If this property is set to any other value it will be used to filter out
            imported data to only include Time Step intervals based on the specified increment value
            of this property.

            If, for example, a Vissim file contains a time step resolution of 0.2 seconds then the
            following values in the file, for a given vehicle, is 0.2, 0.4, 0.6, 0.8, 1.0, 1.2, 1.4,
            etc. If this property is set to a value of 0.6, then only time steps within this increment
            will be imported, such as; 0.6, 1.2, 1.8, etc.

            If this property is set prior to calling the Read method then the filtering will take place
            during the Read method. This can provide a (often much) higher performance if the desired
            step increment is known prior to having examined the contents of a Vissim file.

            Recommendations

            This property is best set before calling the Read method, before calling the FillSelection
            method, or otherwise before calling the ProcessImport method. Keep in mind the following
            behavioral differences:

            - When this property is set (to anything other than -1.0) before Read is called the processing
            of the Read method will skip all vehicles and time steps fit time range criteria. This will
            prevent data to be read and will not occupy any memory and as a result the reading of data
            from the file will be faster, often much faster in multiples of 100%.

            - When this property is set (to anything other than -1.0) after Read() but before FillSelection
            then the start of the FillSelection process will remove all vehicles and time steps from memory
            that fit the time range criteria. This will prevent the ListView control from displaying the
            vehicles and step time data that were removed.

            - When this property is set (to anything other than -1.0) after FillSelection but before
            ProcessImport then the imported data may no longer match the selected data if the selected data
            contained vehicles which matched the time range criteria. These are removed during ProcessImport
            regardless of the selection of vehicles that the user had made.

            - It is possible to repeat the setting of this property and then calling FillSelection in order
            to filter out more vehicles and steps outside of the specified time range . Increasing the value
            of this property and calling FillSelection will cause the removal of more matching vehicles and
            their time step data. It is not possible to lower this value and regain the vehicles that were
            previously removed. The removal is not for display purposes only, the removal is permanent.

            - This property is also applied in the final stages of processing so if other properties such as
            EndTime and/or StartTime cause vehicles to end up with a number of time steps lower than this
            threshold, they will be removed.

            */
            local LOCtimeResArray        = #(((LOCbaseTimeRes) as string), ((LOCbaseTimeRes * 2) as string), ((LOCbaseTimeRes * 3) as string), ((LOCbaseTimeRes * 4) as string), ((LOCbaseTimeRes * 5) as string), ((LOCbaseTimeRes * 6) as string), ((LOCbaseTimeRes * 7) as string), ((LOCbaseTimeRes * 8) as string), ((LOCbaseTimeRes * 9) as string), ((LOCbaseTimeRes * 10) as string), ((LOCbaseTimeRes * 20) as string),  ((LOCbaseTimeRes * 40) as string))
            local LOCtimeStringResArray  = deepCopy LOCtimeResArray
            LOCtimeStringResArray[1] += " " + DYNuiResourcesLabels[382]

            local LOCfileSize            = (DYNFUNfileSize LOCfzpFile) as string
            local LOCselection           = DSIMFUNdisplayListBox DYNuiResourcesTitlebars[31] (DYNuiResourcesLabels[385] + "\n\n" + DYNuiResourcesLabels[383] + " " + LOCfileSize + " " + DYNuiResourcesLabels[384]) LOCtimeStringResArray 1
            local LOCadjustedTimeRes     = LOCtimeResArray[LOCselection] as float
            if LOCadjustedTimeRes != LOCbaseTimeRes then
            (
              dnImportObject.StepIncrement = LOCadjustedTimeRes
              LOCtimeResArray = #(((LOCadjustedTimeRes) as string), ((LOCadjustedTimeRes * 2) as string), ((LOCadjustedTimeRes * 3) as string), ((LOCadjustedTimeRes * 4) as string), ((LOCadjustedTimeRes * 5) as string), ((LOCadjustedTimeRes * 6) as string), ((LOCadjustedTimeRes * 7) as string), ((LOCadjustedTimeRes * 8) as string), ((LOCadjustedTimeRes * 9) as string), ((LOCadjustedTimeRes * 10) as string), ((LOCadjustedTimeRes * 20) as string))
            )
            LBDYNstepIncrement.enabled   = LOCproceedSwitch
            DDDYNstepInc.items           = LOCtimeResArray
            DDDYNstepInc.selection       = 1
            DDDYNstepInc.enabled         = LOCproceedSwitch
          )
        )

        --- Perform the initial read and record the number of lines read (0 if error occured)
        if LOCproceedSwitch then
        (
          LBDYNstatus.text = DYNuiResourcesStatusMessages[33]
          local LOClineCount = dnImportObject.Read()

          if LOClineCount == 0 then
          (
            messagebox dnImportObject.ErrorMessage title:DYNuiResourcesTitlebars[1]
            LOCproceedSwitch = false
          )
        )

        --- If read was successful, fill the LV with the results
        if LOCproceedSwitch then
        (
          --- (fill the lv (success true/false)
          local LOCproceedSwitch = dnImportObject.FillSelection false

          if not LOCproceedSwitch then
          (
            messagebox dnImportObject.ErrorMessage title:DYNuiResourcesTitlebars[1]
          )
        )

        --- Change ImageIndex of Each ListItem
        for i = 1 to dnImportObject.ControlSelectionListView.items.count do
        (
          dnImportObject.ControlSelectionListView.items.item[i-1].ImageIndex = 1
        )
        for i = 1 to dnImportObject.ControlVehTypeListView.items.count do
        (
          dnImportObject.ControlVehTypeListView.items.item[i-1].ImageIndex = 1
        )

        --- If read and LV fill was successful, update other controls in the rollout
        if LOCproceedSwitch then
        (
          SLDYNstartTime.range     = SPDYNstartTime.range     = [dnImportObject.globalStartTime, dnImportObject.globalEndTime, dnImportObject.globalStartTime]
          SLDYNendTime.range       = SPDYNendTime.range       = [dnImportObject.globalStartTime, dnImportObject.globalEndTime, dnImportObject.globalEndTime]
          SPDYNshiftTime.value     = -dnImportObject.globalStartTime
          dnImportObject.ShiftTime = SPDYNshiftTime.value / dnImportObject.SpeedMultiplier

          LBDYNstatus.text             = DYNuiResourcesStatusMessages[30]
          BUDYNokok.enabled            = true

          LOCfzpFilePath = LOCfzpFile
        )
        else
        (
          LBDYNstatus.text             = DYNuiResourcesStatusMessages[16]
        )
      )
    )
  )


  on SPDYNstartTime       changed arg do
  (
    dnImportObject.StartTime = if arg == dnImportObject.GlobalStartTime then -1 else arg
    SLDYNstartTime.value     = arg
  )

  on SLDYNstartTime       changed arg do
  (
    dnImportObject.StartTime = if arg == dnImportObject.GlobalStartTime then -1 else arg
    SPDYNstartTime.value     = arg
  )

  on SPDYNendTime         changed arg do
  (
    dnImportObject.EndTime = if arg == dnImportObject.GlobalEndTime then -1 else arg
    SLDYNendTime.value     = arg
  )

  on SLDYNendTime         changed arg do
  (
    dnImportObject.EndTime = if arg == dnImportObject.GlobalEndTime then -1 else arg
    SPDYNendTime.value     = arg
  )

  on SPDYNstepThreshold   changed arg do ( dnImportObject.StepThreshold      = arg )
  on DDDYNstepInc        selected arg do
  (
    if LOCbaseTimeRes == (DDDYNstepInc.selected as float) then
    (
      dnImportObject.StepIncrement = -1.0
    )
    else
    (
      dnImportObject.StepIncrement = DDDYNstepInc.selected as float
    )
  )

  on SPDYNshiftX          changed arg do ( rootNode.DYNrootNodeStore.int04 = dnImportObject.ShiftX          = arg )
  on SPDYNshiftY          changed arg do ( rootNode.DYNrootNodeStore.int05 = dnImportObject.ShiftY          = arg )
  on SPDYNshiftZ          changed arg do ( rootNode.DYNrootNodeStore.float01 = arg )

  on SPDYNshiftTime       changed arg do ( dnImportObject.ShiftTime       = arg / dnImportObject.SpeedMultiplier)
  on SPDYNspeedMultiplier changed arg do ( dnImportObject.SpeedMultiplier = arg ; dnImportObject.ShiftTime = SPDYNshiftTime.value / arg)

  on BUDYNitemAdd pressed do
  (
    if EDDYNwildCard.text != "" then
    (
      for i = 1 to dnListView1.items.count do
      (
        if (matchPattern dnListView1.items.item[i - 1].name pattern:EDDYNwildCard.text ignoreCase:true) then
        (
          dnListView1.items.item[i - 1].checked = true
        )
      )
    )
    else
    (
      messagebox DYNuiResourcesErrorsWarnings[18] title:DYNuiResourcesTitlebars[3] beep:false
    )
  )

  on BUDYNitemRem pressed do
  (
    if EDDYNwildCard.text != "" then
    (
      for i = 1 to dnListView1.items.count do
      (
        if (matchPattern dnListView1.items.item[i - 1].name pattern:EDDYNwildCard.text ignoreCase:true) then
        (
          dnListView1.items.item[i - 1].checked = false
        )
      )
    )
    else
    (
      messagebox DYNuiResourcesErrorsWarnings[18] title:DYNuiResourcesTitlebars[3] beep:false
    )
  )

  on BUDYNokok pressed do
  (
    if SPDYNstartTime.value >= SPDYNendTime.value then
    (
      messagebox DYNuiResourcesErrorsWarnings[54] title:DYNuiResourcesTitlebars[2]
    )
    else
    (
      if dnListView1.checkedItems.count > 0 then
      (
        local LOCproceedSwitch = true

        --- First, pass the current selection from the LV so that unchecked vehicles can be removed from memory
        LOCproceedSwitch = dnImportObject.SetSelection()

        if not LOCproceedSwitch then
        (
          messagebox dnImportObject.ErrorMessage title:DYNuiResourcesTitlebars[1]
        )

        --- Call the second read or final processing or both (automatic)
        if LOCproceedSwitch then
        (
          local LOClineCount = dnImportObject.ProcessImport()
          /*
          if -1 is returned if the process was just filtering because of single read being used
          */

          if LOClineCount == 0 then
          (
            messagebox dnImportObject.ErrorMessage title:DYNuiResourcesTitlebars[1]
            LOCproceedSwitch = false
          )
        )

        --- Create the selected vehicles
        if LOCproceedSwitch then
        (
          DSIMFUNextendScene()

          DYNFUNremoveCSProllouts()

          actionMan.executeAction 0 "300"
          DYNFUNloadVSPnodeCallBacks
          (
            with redraw off
            (
              dnProgress.value = 0

              local LOCst = timestamp()

              --- get vehicle collection
              local LOCvehs = dnImportObject.vehicles

              --- for each vehicle
              for i = 1 to LOCvehs.count do
              (
                local LOCrawCnt1 = 0
                local LOCrawCnt2 = 0
                local LOCveh     = LOCvehs.item[i - 1]

                dnProgress.value = ((i as float) / (LOCvehs.count as float) * 100.0) as integer
                LBDYNstatus.text = DYNuiResourcesStatusMessages[32] + " : " + (LOCveh.typeString as string) + " " + (LOCveh.number as string)

                --- Set Size of Geometry for Vehicle (Rescale Box Size to convert to current system units)
                local LOCunitMult = 1.0
                case units.SystemType of
                (
                  #Inches      : LOCunitMult = 39.3700787
                  #Feet        : LOCunitMult = 3.2808399
                  #Miles       : LOCunitMult = 0.000621371192
                  #Millimeters : LOCunitMult = 1000.0
                  #Centimeters : LOCunitMult = 100.0
                  #Meters      : LOCunitMult = 1.0
                  #Kilometers  : LOCunitMult = 0.001
                )

                local LOCboxLength       = 5.0 * LOCunitMult
                local LOCboxWidth        = 2.5 * LOCunitMult
                local LOCboxHeight       = 1.5 * LOCunitMult

                --- Create Geometry for Vehicle
                local LOCobj             = box length:LOCboxLength width:LOCboxWidth height:LOCboxHeight pos:[1.0,1.5,0.0]
                LOCobj.objectoffsetpos.y = LOCboxLength / 2.0

                --- Create Position Controller
                local LOCctrlP          = LOCobj.pos.controller      = bezier_position()
                local LOCctrlR          = LOCobj.rotation.controller = bezier_rotation()

                local LOCctrlPkeys      = LOCctrlP.keys
                local LOCctrlRkeys      = LOCctrlR.keys

                --- Create Dummy Scale Controller to hold basic z rotation values (used later for culumative surface tracking)
                /*
                Controller:Civil_View_Traffic_Data_Constraint
                  .float01 : float -- ROTATION QUAT Z
                  .float02 : float -- ROTATION QUAT W
                  .float03 : float -- ROTATION EULER Z
                  .float04 : float
                  .float05 : float
                  .float06 : float
                  .float07 : float
                  .float08 : float
                  .float09 : float
                  .float10 : float
                  .float11 : float
                  .float12 : float
                  .int01 : integer
                  .int02 : integer
                  .int03 : integer
                  .int04 : integer
                  .int05 : integer
                  .bool01 : boolean
                  .bool02 : boolean
                  .bool03 : boolean
                  .bool04 : boolean
                  .bool05 : boolean
                  .string01 : string
                  .string02 : string
                  .string03 : string
                  .string04 : string
                  .string05 : string
                */
                LOCobj.scale.controller = Civil_View_Traffic_Data_Constraint()
                local LOCctrlSe         = LOCobj.scale.controller.float03.controller = bezier_float()
                local LOCctrlSeKeys     = LOCctrlSe.keys

                --- Get Array of Step and Coordinate Data (Option 1)
                /*
                /// GetVehicleDataRaw [float[] coordinates = new float[7 * vehicles[vehicleIndex].Steps.Count];]
                /// An array of float with a length of 7 times the step count. The data in the array is a repeated series of 7
                /// items for step time, fx coordinate, fy coordinate, fz coordinate, rx coordinate, ry coordinate, rz coordinate.
                */
                local LOCrawArray = dnImportObject.GetVehicleDataRaw[i - 1]

                /*
                /// GetVehicleData [float[] coordinates = new float[5 * vehicles[vehicleIndex].Steps.Count];]
                /// An array of float with a length of 5 times the step count. The data in the array is a repeated series of 5
                /// items for step time, x coordinate, y coordinate, z coordinate, rotation.
                */
                --local LOCblArray = dnImportObject.GetVehicleData[i - 1]

                /*
                /// GetVehicleDataQuat
                /// An array of float with a length of 6 times the step count. The data in the array is a repeated series of 6
                /// items for step time, x coordinate, y coordinate, z coordinate, quaternion z, quaternion w.
                */
                local LOCcoArray = dnImportObject.GetVehicleDataQuat[i - 1]

                for ii = 1 to LOCcoArray.count by 6 do
                (
                  /*
                     This section is slower than we would like. The bottleneck here, is the "AddNewKey" command.
                     In benchmark tests on "AshordTrimmed.fzp", the following takes around 39 seconds to process for
                     all vehicles.

                     If key.value is removed, this does down to 22 seconds.
                     If AddNewKey is removed all together, this goes down to five seconds.

                     Actually building the quat and point3 values is negligable in terms of performance.
                  */
                  local LOCframe    = LOCcoArray[ii] * frameRate

                  LOCrawCnt1 += 1
                  LOCrawCnt2               = ii + LOCrawCnt1
                  local LOCfrontXYZ        = [LOCrawArray[LOCrawCnt2], LOCrawArray[LOCrawCnt2+1], LOCrawArray[LOCrawCnt2+2]]
                  local LOCnewKeyP         = addNewKey LOCctrlPkeys  (LOCframe); LOCnewKeyP.value  = [LOCfrontXYZ.x, LOCfrontXYZ.y, (LOCcoArray[ii+3] + SPDYNshiftZ.value)]
                  local LOCnewKeyR         = addNewKey LOCctrlRkeys  (LOCframe); LOCnewKeyR.value  = quat 0.0 0.0 LOCcoArray[ii+4] LOCcoArray[ii+5]
                  local LOCnewKeySe        = addNewKey LOCctrlSeKeys (LOCframe); LOCnewKeySe.value = ((quat 0.0 0.0 LOCcoArray[ii+4] LOCcoArray[ii+5]) as eulerangles).z
                )

                --- Add AppData for Vehicle (matches standard vehicle appData except 424)
                local LOCappData425 = (DYNFUNgetLocalTime()) + "|" + LOCfzpFile + "|" + (LOCveh.number as string) + "|" + (LOCveh.typeString as string)
                DYNFUNgenObjAppData LOCobj 1 0 "" LOCappData425 "0" "0" DYNINIshadowSaver

                --- for DSIM vehicles, reset 421 from "Dynamite" to "DSIM"
                setAppData LOCobj 421 "DSIM"

                --- Update Object Name
                LOCobj.name = uniqueName (DYNuiResourcesNodeNames[3] + (LOCveh.typeString as string) + "-")
              )
              rootNode.DYNrootNodeStore.string03 = LOCfzpFilePath
            )

            local LOCen = timestamp()
            LBDYNstatus.text = DYNuiResourcesStatusMessages[31] + " (" + (((LOCen - LOCst) / 1000.0) as string) + DYNuiResourcesUnitsTime[2] + ")"
            sleep 1

            dnProgress.value = 0

            destroyDialog DYNdsimImport
            if LOCobjectsAlreadyExist == false then (max tool zoomextents all; max tool zoomextents all)
          )
        )
        DYNFUNloadVSPnodeCallBacks true
        DYNFUNnodeCreatedCallback()
      )
      else
      (
        messagebox (DYNuiResourcesErrorsWarnings[53]) title:DYNuiResourcesTitlebars[1]
      )
    )
  )

  on BUDYNcanc pressed do
  (
    destroyDialog DYNdsimImport
  )

  on BUDYNhelp pressed do DYNFUNopenHelp 13218 -- id_cv_traffic_import
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCilic3ya7JC/dB3XUvUwkPEjhK/bJVU2a+
-- RJoGRP83+ryUXK2iUuORVH4rSuJjRJByRgWRg8O6kXxteYDhBfTWvzDr9gEb1qEb
-- OLbUCQLCxnMrtQ3JR3wopgHwSx8JV8wDDGZwDOe6feFqDGmfpw6pnqqYbm7kfOSI
-- xZ0iAKAUCHXqluPvE+QhLZP304tY3j2Mb3GYHJCiyZSXj27zQsFrL2y6jOvZ9b7l
-- ath0vvHLclqeWk43+xDuqSquSF8ZgnN1o4Gn4DmVAydps3RYC67xtwLuhBjWN2mf
-- V/LHfsXNpD9ZEVBQY09QLRR81bguteA+CflKQ08DLPAQMQ8+zKX5
-- -----END-SIGNATURE-----